/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HeartmenderEffect
extends OneShotEffect {
    private final Counter counter;

    HeartmenderEffect(Counter counter) {
        super(Outcome.BoostCreature);
        this.counter = counter;
        this.staticText = "remove a -1/-1 counter from each creature you control";
    }

    private HeartmenderEffect(HeartmenderEffect effect) {
        super((OneShotEffect)effect);
        this.counter = effect.counter.copy();
    }

    public boolean apply(Game game, Ability source) {
        boolean applied = false;
        if (game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), game).isEmpty()) {
            return true;
        }
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), game)) {
            if (creature == null || creature.getCounters(game).getCount(this.counter.getName()) < this.counter.getCount()) continue;
            creature.removeCounters(this.counter.getName(), this.counter.getCount(), source, game);
            game.informPlayers("Removed " + this.counter.getCount() + ' ' + this.counter.getName() + " counter from " + creature.getName());
            applied = true;
        }
        return applied;
    }

    public HeartmenderEffect copy() {
        return new HeartmenderEffect(this);
    }
}

