/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HeartwarmingRedemptionEffect
extends OneShotEffect {
    HeartwarmingRedemptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Discard all the cards in your hand, then draw that many cards plus one. You gain life equal to the number of cards in your hand.";
    }

    private HeartwarmingRedemptionEffect(HeartwarmingRedemptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeartwarmingRedemptionEffect copy() {
        return new HeartwarmingRedemptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int discarded = player.discard(player.getHand().size(), false, false, source, game).size();
        player.drawCards(discarded + 1, source, game);
        player.gainLife(player.getHand().size(), game, source);
        return true;
    }
}

