/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HedonistsTroveExileEffect
extends OneShotEffect {
    HedonistsTroveExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile target opponent's graveyard";
    }

    private HedonistsTroveExileEffect(HedonistsTroveExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public HedonistsTroveExileEffect copy() {
        return new HedonistsTroveExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        game.getState().setValue(source.getSourceId().toString(), (Object)exileId);
        return controller != null && targetPlayer != null && controller.moveCardsToExile(targetPlayer.getGraveyard().getCards(game), source, game, true, exileId, CardUtil.getSourceName((Game)game, (Ability)source));
    }
}

