/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

public final class HeedTheMists
extends CardImpl {
    public HeedTheMists(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{3}{U}{U}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addEffect((Effect)new HeedTheMistsEffect());
    }

    private HeedTheMists(HeedTheMists card) {
        super((CardImpl)card);
    }

    public HeedTheMists copy() {
        return new HeedTheMists(this);
    }

    private static class HeedTheMistsEffect
    extends OneShotEffect {
        public HeedTheMistsEffect() {
            super(Outcome.DrawCard);
            this.staticText = "Mill a card, then draw cards equal to the milled card's mana value";
        }

        private HeedTheMistsEffect(HeedTheMistsEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Player controller = game.getPlayer(source.getControllerId());
            int totalCMC = controller.millCards(1, source, game).getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
            controller.drawCards(totalCMC, source, game);
            return true;
        }

        public HeedTheMistsEffect copy() {
            return new HeedTheMistsEffect(this);
        }
    }
}

