/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HeliodsPunishmentEffect
extends OneShotEffect {
    UUID sourceEnchantmentId;

    public HeliodsPunishmentEffect(String sourceName) {
        super(Outcome.Benefit);
        this.staticText = "Remove a task counter from " + sourceName + ". Then if it has no task counters on it, destroy " + sourceName + ".";
        this.sourceEnchantmentId = null;
    }

    private HeliodsPunishmentEffect(HeliodsPunishmentEffect effect) {
        super((OneShotEffect)effect);
        this.sourceEnchantmentId = effect.sourceEnchantmentId;
    }

    public HeliodsPunishmentEffect copy() {
        return new HeliodsPunishmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourceEnchantment = game.getPermanent(this.sourceEnchantmentId);
        if (sourceEnchantment != null) {
            if (sourceEnchantment.getCounters(game).getCount(CounterType.TASK) > 0) {
                sourceEnchantment.removeCounters(CounterType.TASK.createInstance(1), source, game);
                if (!game.isSimulation()) {
                    game.informPlayers("Removed a task counter from " + sourceEnchantment.getLogName());
                }
            }
            if (sourceEnchantment.getCounters(game).getCount(CounterType.TASK) == 0) {
                sourceEnchantment.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }

    public void setSourceEnchantment(UUID sourceEnchantment) {
        this.sourceEnchantmentId = sourceEnchantment;
    }
}

