/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.h.HeliodsPunishmentEffect;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HeliodsPunishmentLoseAllAbilitiesEnchantedEffect
extends ContinuousEffectImpl {
    HeliodsPunishmentLoseAllAbilitiesEnchantedEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.LoseAbility);
        this.staticText = "It loses all abilities and has \"{T}: Remove a task counter from {this}. Then if it has no task counters on it, destroy {this}.\"";
    }

    private HeliodsPunishmentLoseAllAbilitiesEnchantedEffect(HeliodsPunishmentLoseAllAbilitiesEnchantedEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HeliodsPunishmentLoseAllAbilitiesEnchantedEffect copy() {
        return new HeliodsPunishmentLoseAllAbilitiesEnchantedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attachedTo;
        Permanent sourceEnchantment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourceEnchantment != null && sourceEnchantment.getAttachedTo() != null && (attachedTo = game.getPermanent(sourceEnchantment.getAttachedTo())) != null) {
            attachedTo.removeAllAbilities(source.getSourceId(), game);
            HeliodsPunishmentEffect effect = new HeliodsPunishmentEffect(sourceEnchantment.getName());
            SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)effect, (Cost)new TapSourceCost());
            effect.setSourceEnchantment(sourceEnchantment.getId());
            attachedTo.addAbility((Ability)ability, source.getSourceId(), game);
        }
        return true;
    }
}

