/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.TreasureToken;
import mage.util.CardUtil;

class HellToPayEffect
extends OneShotEffect {
    HellToPayEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals X damage to target creature. Create a number of tapped Treasure tokens equal to the amount of excess damage dealt to that creature this way";
    }

    private HellToPayEffect(HellToPayEffect effect) {
        super((OneShotEffect)effect);
    }

    public HellToPayEffect copy() {
        return new HellToPayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game);
        if (excess > 0) {
            new TreasureToken().putOntoBattlefield(excess, game, source, source.getControllerId(), true, false);
        }
        return true;
    }
}

