/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HelldozerEffect
extends OneShotEffect {
    HelldozerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target land. If that land was nonbasic, untap {this}";
    }

    private HelldozerEffect(HelldozerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HelldozerEffect copy() {
        return new HelldozerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent helldozer = game.getPermanent(source.getSourceId());
        Permanent landTarget = game.getPermanent(source.getFirstTarget());
        if (landTarget != null) {
            boolean wasNonBasic = !landTarget.isBasic(game);
            landTarget.destroy(source, game, false);
            if (wasNonBasic && helldozer != null) {
                return helldozer.untap(game);
            }
        }
        return false;
    }
}

