/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HellionToken;

class HellionEruptionEffect
extends OneShotEffect {
    HellionEruptionEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Sacrifice all creatures you control, then create that many 4/4 red Hellion creature tokens";
    }

    private HellionEruptionEffect(HellionEruptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public HellionEruptionEffect copy() {
        return new HellionEruptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            permanent.sacrifice(source, game);
        }
        new HellionToken().putOntoBattlefield(permanents.size(), game, source, source.getControllerId());
        return true;
    }
}

