/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HellkiteCourserReturnEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    HellkiteCourserReturnEffect(Permanent permanent, Game game) {
        super(Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)permanent, game);
        this.staticText = "return it to the command zone";
    }

    private HellkiteCourserReturnEffect(HellkiteCourserReturnEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public HellkiteCourserReturnEffect copy() {
        return new HellkiteCourserReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = this.mor.getPermanent(game);
        if (player == null || permanent == null) {
            return false;
        }
        return player.moveCards((Card)permanent, Zone.COMMAND, source, game);
    }
}

