/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HellriderTriggeredAbility
extends TriggeredAbilityImpl {
    public HellriderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1));
    }

    private HellriderTriggeredAbility(HellriderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HellriderTriggeredAbility copy() {
        return new HellriderTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source = game.getPermanent(event.getSourceId());
        if (source != null && source.isControlledBy(this.controllerId)) {
            UUID defendingPlayerId = game.getCombat().getDefenderId(event.getSourceId());
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defendingPlayerId));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature you control attacks, {this} deals 1 damage to the player or planeswalker it's attacking.";
    }
}

