/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class HeraldsHornEffect
extends OneShotEffect {
    HeraldsHornEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a creature card of the chosen type, you may reveal it and put it into your hand";
    }

    private HeraldsHornEffect(HeraldsHornEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeraldsHornEffect copy() {
        return new HeraldsHornEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && controller.getLibrary().hasCards() && sourceObject != null) {
            Card card = controller.getLibrary().getFromTop(game);
            CardsImpl cards = new CardsImpl(card);
            controller.lookAtCards(sourceObject.getIdName(), (Cards)cards, game);
            FilterCreatureCard filter = new FilterCreatureCard("creature card of the chosen type");
            SubType subtype = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
            if (subtype == null) {
                return true;
            }
            filter.add((Predicate)subtype.getPredicate());
            String message = "Reveal the top card of your library and put that card into your hand?";
            if (card != null && filter.match(card, game) && controller.chooseUse(Outcome.Benefit, message, source, game)) {
                controller.moveCards(card, Zone.HAND, source, game);
                controller.revealCards(sourceObject.getIdName() + " put into hand", (Cards)cards, game);
                return true;
            }
        }
        return false;
    }
}

