/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EmergeAbility;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class HerigastEruptingNullkiteEffect
extends ContinuousEffectImpl {
    HerigastEruptingNullkiteEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Each creature spell you cast has emerge. The emerge cost is equal to its mana cost.";
    }

    private HerigastEruptingNullkiteEffect(HerigastEruptingNullkiteEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet cardsToGainEmerge = new HashSet();
        cardsToGainEmerge.addAll(controller.getHand().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        cardsToGainEmerge.addAll(controller.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        controller.getLibrary().getCards(game).stream().filter(c -> StaticFilters.FILTER_CARD_CREATURE.match(c, game)).forEach(cardsToGainEmerge::add);
        game.getExile().getCardsInRange(game, controller.getId()).stream().filter(c -> StaticFilters.FILTER_CARD_CREATURE.match(c, game)).forEach(cardsToGainEmerge::add);
        game.getCommanderCardsFromCommandZone(controller, CommanderCardType.ANY).stream().filter(card -> StaticFilters.FILTER_CARD_CREATURE.match(card, game)).forEach(cardsToGainEmerge::add);
        game.getStack().stream().filter(Spell.class::isInstance).filter(s -> s.isControlledBy(controller.getId())).filter(s -> StaticFilters.FILTER_CARD_CREATURE.match((Card)((Spell)s), game)).map(s -> game.getCard(s.getSourceId())).filter(Objects::nonNull).forEach(cardsToGainEmerge::add);
        for (Card card2 : cardsToGainEmerge) {
            if (card2.getManaCost().getText().isEmpty()) continue;
            EmergeAbility ability = new EmergeAbility(card2, card2.getManaCost().getText());
            ability.setSourceId(card2.getId());
            ability.setControllerId(card2.getControllerOrOwnerId());
            game.getState().addOtherAbility(card2, (Ability)ability);
        }
        return true;
    }

    public HerigastEruptingNullkiteEffect copy() {
        return new HerigastEruptingNullkiteEffect(this);
    }
}

