/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HeroOfLeinaTowerEffect
extends OneShotEffect {
    HeroOfLeinaTowerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "you may pay {X}. If you do, put X +1/+1 counters on {this}";
    }

    private HeroOfLeinaTowerEffect(HeroOfLeinaTowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeroOfLeinaTowerEffect copy() {
        return new HeroOfLeinaTowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (you != null && you.chooseUse(Outcome.BoostCreature, "Do you want to to pay {X}?", source, game)) {
            Permanent sourcePermanent;
            int costX = you.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to add +1/+1 counters)", game, source, true);
            cost.add((Object)new GenericManaCost(costX));
            if (cost.pay(source, game, source, source.getControllerId(), false, null) && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
                return new AddCountersSourceEffect(CounterType.P1P1.createInstance(costX), true).apply(game, source);
            }
        }
        return false;
    }
}

