/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ToxicAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HexgoldSlashEffect
extends OneShotEffect {
    HexgoldSlashEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to target creature. If that creature has toxic, {this} deals 4 damage to that creature instead";
    }

    private HexgoldSlashEffect(HexgoldSlashEffect effect) {
        super((OneShotEffect)effect);
    }

    public HexgoldSlashEffect copy() {
        return new HexgoldSlashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            if (permanent.getAbilities(game).containsClass(ToxicAbility.class)) {
                permanent.damage(4, source, game);
            } else {
                permanent.damage(2, source, game);
            }
            return true;
        }
        return false;
    }
}

