/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;

class HezrouTriggeredAbility
extends TriggeredAbilityImpl {
    HezrouTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever one or more creatures you control become blocked, ");
    }

    private HezrouTriggeredAbility(HezrouTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARE_BLOCKERS_STEP || event.getType() == GameEvent.EventType.BATCH_BLOCK_NONCOMBAT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        switch (event.getType()) {
            case DECLARE_BLOCKERS_STEP: {
                return game.getCombat().getGroups().stream().filter(CombatGroup::getBlocked).map(CombatGroup::getAttackers).flatMap(Collection::stream).map(arg_0 -> ((Game)game).getControllerId(arg_0)).anyMatch(this.getControllerId()::equals);
            }
            case BATCH_BLOCK_NONCOMBAT: {
                Object value = game.getState().getValue("becameBlocked_" + event.getData());
                if (!(value instanceof Set)) {
                    return false;
                }
                Set permanents = (Set)value;
                return permanents.stream().map(mor -> mor.getPermanentOrLKIBattlefield(game)).filter(Objects::nonNull).map(Controllable::getControllerId).anyMatch(this.getControllerId()::equals);
            }
        }
        return false;
    }

    public HezrouTriggeredAbility copy() {
        return new HezrouTriggeredAbility(this);
    }
}

