/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveVariableCountersTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class HierophantBioTitanCostReductionEffect
extends CostModificationEffectImpl {
    HierophantBioTitanCostReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "As an additional cost to cast this spell, you may remove any number of +1/+1 counters from among creatures you control. This spell costs {2} less to cast for each counter removed this way.";
    }

    private HierophantBioTitanCostReductionEffect(HierophantBioTitanCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        int reduction = 0;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof RemoveVariableCountersTargetCost)) continue;
            reduction = game.inCheckPlayableState() ? ((RemoveVariableCountersTargetCost)cost).getMaxValue((Ability)spellAbility, game) : ((RemoveVariableCountersTargetCost)cost).getAmount();
            break;
        }
        CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public HierophantBioTitanCostReductionEffect copy() {
        return new HierophantBioTitanCostReductionEffect(this);
    }
}

