/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.Mana;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.AddManaToManaPoolTargetControllerEffect;
import mage.abilities.mana.DelayedTriggeredManaAbility;
import mage.constants.ColoredManaSymbol;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HighTideTriggeredAbility
extends DelayedTriggeredManaAbility {
    HighTideTriggeredAbility() {
        super((Effect)new AddManaToManaPoolTargetControllerEffect(new Mana(ColoredManaSymbol.U), "their"), Duration.EndOfTurn, Boolean.valueOf(false));
        this.usesStack = false;
    }

    private HighTideTriggeredAbility(HighTideTriggeredAbility ability) {
        super((DelayedTriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = ((TappedForManaEvent)event).getPermanent();
        if (permanent == null || !permanent.hasSubtype(SubType.ISLAND, game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent.getControllerId()));
        return true;
    }

    public HighTideTriggeredAbility copy() {
        return new HighTideTriggeredAbility(this);
    }

    public String getRule() {
        return "Until end of turn, whenever a player taps an Island for mana, that player adds {U}";
    }
}

