/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.costs.common.DiscardTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class HisokaMinamoSenseiCounterEffect
extends OneShotEffect {
    HisokaMinamoSenseiCounterEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell if it has the same mana value as the discarded card";
    }

    private HisokaMinamoSenseiCounterEffect(HisokaMinamoSenseiCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        if (CardUtil.castStream((Stream)source.getCosts().stream(), DiscardTargetCost.class).map(DiscardTargetCost::getCards).flatMap(Collection::stream).anyMatch(card -> card.getManaValue() == spell.getManaValue())) {
            return game.getStack().counter(this.getTargetPointer().getFirst(game, source), source, game);
        }
        return false;
    }

    public HisokaMinamoSenseiCounterEffect copy() {
        return new HisokaMinamoSenseiCounterEffect(this);
    }
}

