/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class HitTheMotherLodeEffect
extends OneShotEffect {
    HitTheMotherLodeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Discover 10. If the discovered card's mana value is less than 10, create a number of tapped Treasure tokens equal to the difference.";
    }

    private HitTheMotherLodeEffect(HitTheMotherLodeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HitTheMotherLodeEffect copy() {
        return new HitTheMotherLodeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int value;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = DiscoverEffect.doDiscover((Player)controller, (int)10, (Game)game, (Ability)source);
        int n = value = card == null ? 0 : card.getManaValue();
        if (value >= 10) {
            return false;
        }
        return new CreateTokenEffect((Token)new TreasureToken(), 10 - value, true).apply(game, source);
    }
}

