/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HoardersGreedEffect
extends OneShotEffect {
    HoardersGreedEffect() {
        super(Outcome.Benefit);
        this.staticText = "You lose 2 life and draw two cards, then clash with an opponent. If you win, repeat this process";
    }

    private HoardersGreedEffect(HoardersGreedEffect effect) {
        super((OneShotEffect)effect);
    }

    public HoardersGreedEffect copy() {
        return new HoardersGreedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            do {
                controller.loseLife(2, game, source, false);
                controller.drawCards(2, source, game);
            } while (controller.canRespond() && new ClashEffect().apply(game, source));
            return true;
        }
        return false;
    }
}

