/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HolisticWisdomEffect
extends OneShotEffect {
    HolisticWisdomEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target card from your graveyard to your hand if it shares a card type with the card exiled this way";
    }

    private HolisticWisdomEffect(HolisticWisdomEffect effect) {
        super((OneShotEffect)effect);
    }

    public HolisticWisdomEffect copy() {
        return new HolisticWisdomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(source.getFirstTarget());
        if (card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof ExileFromHandCost)) continue;
                ArrayList<CardType> cardtypes = new ArrayList<CardType>();
                ExileFromHandCost exileCost = (ExileFromHandCost)cost;
                for (CardType cardtype : ((Card)exileCost.getCards().get(0)).getCardType(game)) {
                    cardtypes.add(cardtype);
                }
                for (CardType cardtype : card.getCardType(game)) {
                    if (!cardtypes.contains(cardtype)) continue;
                    ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                    return effect.apply(game, source);
                }
            }
        }
        return false;
    }
}

