/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class HollowMarauderEffect
extends OneShotEffect {
    HollowMarauderEffect() {
        super(Outcome.Benefit);
        this.staticText = "any number of target opponents each discard a card. For each of those opponents who didn't discard a card with mana value 4 or greater, draw a card";
    }

    private HollowMarauderEffect(HollowMarauderEffect effect) {
        super((OneShotEffect)effect);
    }

    public HollowMarauderEffect copy() {
        return new HollowMarauderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = 0;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Card card;
            Player opponent = game.getPlayer(targetId);
            if (opponent == null || (card = opponent.discard(1, false, false, source, game).getRandom(game)) != null && card.getManaValue() >= 4) continue;
            ++count;
        }
        if (count < 1) {
            return true;
        }
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.drawCards(count, source, game);
        }
        return true;
    }
}

