/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;
import mage.watchers.common.CardsCycledOrDiscardedThisTurnWatcher;

class HollowOneReductionEffect
extends CostModificationEffectImpl {
    HollowOneReductionEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "this spell costs {2} less to cast for each card you've cycled or discarded this turn";
    }

    protected HollowOneReductionEffect(HollowOneReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardsCycledOrDiscardedThisTurnWatcher watcher = (CardsCycledOrDiscardedThisTurnWatcher)game.getState().getWatcher(CardsCycledOrDiscardedThisTurnWatcher.class);
        if (watcher != null) {
            CardUtil.reduceCost((Ability)abilityToModify, (int)(watcher.getNumberOfCardsCycledOrDiscardedThisTurn(source.getControllerId()) * 2));
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId()) && game.getCard(abilityToModify.getSourceId()) != null;
    }

    public HollowOneReductionEffect copy() {
        return new HollowOneReductionEffect(this);
    }
}

