/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapTargetCost;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.filter.predicate.permanent.BlockingPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.common.TargetControlledPermanent;

class HollowWarriorCostToAttackBlockEffect
extends PayCostToAttackBlockEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("an untapped creature you control not declared as an attacking or blocking creature");

    HollowWarriorCostToAttackBlockEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK_AND_BLOCK, (Cost)new TapTargetCost(new TargetControlledPermanent((FilterControlledPermanent)filter)));
        this.staticText = "{this} can't attack or block unless you tap an untapped creature you control not declared as an attacking or blocking creature this combat <i>(This cost is paid as attackers are declared.)</i>";
    }

    private HollowWarriorCostToAttackBlockEffect(HollowWarriorCostToAttackBlockEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getSourceId());
    }

    public HollowWarriorCostToAttackBlockEffect copy() {
        return new HollowWarriorCostToAttackBlockEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)AttackingPredicate.instance));
        filter.add(Predicates.not((Predicate)BlockingPredicate.instance));
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

