/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HolyJusticiarEffect
extends OneShotEffect {
    HolyJusticiarEffect() {
        super(Outcome.Detriment);
        this.staticText = "Tap target creature. If that creature is a Zombie, exile it";
    }

    private HolyJusticiarEffect(HolyJusticiarEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (player == null || creature == null) {
            return false;
        }
        creature.tap(source, game);
        if (creature.hasSubtype(SubType.ZOMBIE, game)) {
            player.moveCards((Card)creature, Zone.EXILED, source, game);
        }
        return true;
    }

    public HolyJusticiarEffect copy() {
        return new HolyJusticiarEffect(this);
    }
}

