/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HoodedHorrorCantBeBlockedEffect
extends RestrictionEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public HoodedHorrorCantBeBlockedEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't be blocked as long as defending player controls the most creatures or is tied for the most";
    }

    private HoodedHorrorCantBeBlockedEffect(HoodedHorrorCantBeBlockedEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId()) && permanent.isAttacking();
    }

    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int maxCreatures = 0;
            UUID playerIdWithMax = null;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int creatures = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
                if (creatures <= maxCreatures && (creatures != maxCreatures || !playerId.equals(blocker.getControllerId()))) continue;
                maxCreatures = creatures;
                playerIdWithMax = playerId;
            }
            return playerIdWithMax == null || !playerIdWithMax.equals(blocker.getControllerId());
        }
        return true;
    }

    public HoodedHorrorCantBeBlockedEffect copy() {
        return new HoodedHorrorCantBeBlockedEffect(this);
    }
}

