/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class HopeOfGhirapurCombatDamageWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> combatDamagedPlayers = new HashMap<MageObjectReference, Set<UUID>>();

    public HopeOfGhirapurCombatDamageWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedPlayerEvent)event).isCombatDamage()) {
            Set<Object> players;
            MageObjectReference damager = new MageObjectReference(event.getSourceId(), game);
            if (this.combatDamagedPlayers.containsKey(damager)) {
                players = this.combatDamagedPlayers.get(damager);
            } else {
                players = new HashSet();
                this.combatDamagedPlayers.put(damager, players);
            }
            players.add(event.getTargetId());
        }
    }

    public boolean playerGotCombatDamage(UUID objectId, UUID playerId, Game game) {
        StackObject stackObject = game.getState().getStack().getStackObject(objectId);
        MageObjectReference mor = stackObject instanceof StackAbility ? new MageObjectReference(objectId, ((StackAbility)stackObject).getStackMomentSourceZCC(), game) : new MageObjectReference(objectId, game);
        if (this.combatDamagedPlayers.containsKey(mor)) {
            return this.combatDamagedPlayers.get(mor).contains(playerId);
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.combatDamagedPlayers.clear();
    }
}

