/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.ElementalShamanToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;

class HostilityEffect
extends PreventionEffectImpl {
    HostilityEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If a spell you control would deal damage to an opponent, prevent that damage. Create a 3/1 red Elemental Shaman creature token with haste for each 1 damage prevented this way.";
    }

    private HostilityEffect(HostilityEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public HostilityEffect copy() {
        return new HostilityEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell;
        return super.applies(event, source, game) && game.getOpponents(source.getControllerId()).contains(event.getTargetId()) && (spell = game.getStack().getSpell(event.getSourceId())) != null && spell.isControlledBy(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionEffectData = this.preventDamageAction(event, source, game);
        if (preventionEffectData.getPreventedDamage() > 0) {
            new CreateTokenEffect((Token)new ElementalShamanToken(true), preventionEffectData.getPreventedDamage()).apply(game, source);
        }
        return true;
    }
}

