/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HourOfGloryEffect
extends OneShotEffect {
    HourOfGloryEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature. If that creature was a God, its controller reveals their hand and exiles all cards with the same name as that creature";
    }

    private HourOfGloryEffect(HourOfGloryEffect effect) {
        super((OneShotEffect)effect);
    }

    public HourOfGloryEffect copy() {
        return new HourOfGloryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null) {
                controller.moveCards((Card)targetCreature, Zone.EXILED, source, game);
                if (targetCreature.hasSubtype(SubType.GOD, game)) {
                    game.processAction();
                    Player targetController = game.getPlayer(targetCreature.getControllerId());
                    if (targetController != null) {
                        targetController.revealCards(sourceObject.getIdName(), targetController.getHand(), game);
                        HashSet<Card> toExile = new HashSet<Card>();
                        for (Card card : targetController.getHand().getCards(game)) {
                            if (!card.getName().equals(targetCreature.getName())) continue;
                            toExile.add(card);
                        }
                        targetController.moveCards(toExile, Zone.EXILED, source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

