/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class HowToStartARiotEffect
extends OneShotEffect {
    HowToStartARiotEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new SecondTargetPointer());
        this.staticText = "creatures target player controls get +2/+0 until end of turn";
        this.concatBy("<br>");
    }

    private HowToStartARiotEffect(HowToStartARiotEffect effect) {
        super((OneShotEffect)effect);
    }

    public HowToStartARiotEffect copy() {
        return new HowToStartARiotEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        game.addEffect((ContinuousEffect)new BoostAllEffect(2, 0, Duration.EndOfTurn, filter, false), source);
        return true;
    }
}

