/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.abilities.effects.common.CopyPermanentEffect;
import mage.abilities.keyword.PrototypeAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

public final class HulkingMetamorph
extends CardImpl {
    private static final CopyApplier applier = new CopyApplier(){

        public boolean apply(Game game, MageObject blueprint, Ability source, UUID copyToObjectId) {
            blueprint.addCardType(new CardType[]{CardType.ARTIFACT});
            blueprint.addCardType(new CardType[]{CardType.CREATURE});
            Permanent permanent = game.getPermanentEntering(copyToObjectId);
            if (permanent != null) {
                int pt = permanent.isPrototyped() ? 3 : 7;
                blueprint.getPower().setModifiedBaseValue(pt);
                blueprint.getToughness().setModifiedBaseValue(pt);
            }
            return true;
        }
    };

    public HulkingMetamorph(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{9}");
        this.subtype.add((Object)SubType.SHAPESHIFTER);
        this.power = new MageInt(7);
        this.toughness = new MageInt(7);
        this.addAbility((Ability)new PrototypeAbility((Card)this, "{2}{U}{U}", 3, 3));
        this.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new EntersBattlefieldEffect((Effect)new CopyPermanentEffect((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_ARTIFACT_OR_CREATURE, applier).setText("you may have {this} enter the battlefield as a copy of an artifact or creature you control, except it's an artifact creature in addition to its other types, and its power and toughness are equal to {this}'s power and toughness"), "", true)));
    }

    private HulkingMetamorph(HulkingMetamorph card) {
        super((CardImpl)card);
    }

    public HulkingMetamorph copy() {
        return new HulkingMetamorph(this);
    }
}

