/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class Humility
extends CardImpl {
    public Humility(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new HumilityEffect(Duration.WhileOnBattlefield)));
    }

    private Humility(Humility card) {
        super((CardImpl)card);
    }

    public Humility copy() {
        return new Humility(this);
    }

    static class HumilityEffect
    extends ContinuousEffectImpl {
        public HumilityEffect(Duration duration) {
            super(duration, Outcome.LoseAbility);
            this.staticText = "All creatures lose all abilities and have base power and toughness 1/1";
        }

        private HumilityEffect(HumilityEffect effect) {
            super((ContinuousEffectImpl)effect);
        }

        public HumilityEffect copy() {
            return new HumilityEffect(this);
        }

        public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null) {
                return false;
            }
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                switch (layer) {
                    case AbilityAddingRemovingEffects_6: {
                        permanent.removeAllAbilities(source.getSourceId(), game);
                        break;
                    }
                    case PTChangingEffects_7: {
                        if (sublayer != SubLayer.SetPT_7b) break;
                        permanent.getPower().setModifiedBaseValue(1);
                        permanent.getToughness().setModifiedBaseValue(1);
                    }
                }
            }
            return true;
        }

        public boolean apply(Game game, Ability source) {
            return false;
        }

        public boolean hasLayer(Layer layer) {
            return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.PTChangingEffects_7;
        }
    }
}

