/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.watchers.common.BlockedAttackerWatcher;

class HuntDownEffect
extends RequirementEffect {
    HuntDownEffect() {
        this(Duration.EndOfTurn);
    }

    public HuntDownEffect(Duration duration) {
        super(duration);
        this.staticText = "Target creature blocks target creature this turn if able";
    }

    private HuntDownEffect(HuntDownEffect effect) {
        super((RequirementEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent blocker;
        if (permanent.getId().equals(((Target)source.getTargets().get(0)).getFirstTarget()) && (blocker = game.getPermanent(((Target)source.getTargets().get(0)).getFirstTarget())) != null && blocker.canBlock(((Target)source.getTargets().get(1)).getFirstTarget(), game)) {
            Permanent attacker = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
            if (attacker != null) {
                BlockedAttackerWatcher blockedAttackerWatcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class);
                return blockedAttackerWatcher == null || !blockedAttackerWatcher.creatureHasBlockedAttacker(attacker, blocker, game);
            }
            this.discard();
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return true;
    }

    public UUID mustBlockAttacker(Ability source, Game game) {
        return ((Target)source.getTargets().get(1)).getFirstTarget();
    }

    public HuntDownEffect copy() {
        return new HuntDownEffect(this);
    }
}

