/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.h.HuntingWildsToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class HuntingWildsEffect
extends OneShotEffect {
    HuntingWildsEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "Untap all Forests put onto the battlefield this way. They become 3/3 green creatures with haste that are still lands";
    }

    private HuntingWildsEffect(HuntingWildsEffect effect) {
        super((OneShotEffect)effect);
    }

    public HuntingWildsEffect copy() {
        return new HuntingWildsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Effect sourceEffect : source.getEffects()) {
            if (!(sourceEffect instanceof SearchLibraryPutInPlayEffect)) continue;
            CardsImpl foundCards = new CardsImpl((Collection)((SearchLibraryPutInPlayEffect)sourceEffect).getTargets());
            if (!foundCards.isEmpty()) {
                FixedTargets blueprintTarget = new FixedTargets((Cards)foundCards, game);
                UntapTargetEffect untapEffect = new UntapTargetEffect();
                untapEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                untapEffect.apply(game, source);
                BecomesCreatureTargetEffect becomesCreatureEffect = new BecomesCreatureTargetEffect((Token)new HuntingWildsToken(), false, true, Duration.Custom);
                becomesCreatureEffect.setTargetPointer((TargetPointer)blueprintTarget.copy());
                game.addEffect((ContinuousEffect)becomesCreatureEffect, source);
            }
            return true;
        }
        return false;
    }
}

