/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class HurkylMasterWizardWatcher
extends Watcher {
    private final Map<UUID, Set<CardType>> map = new HashMap<UUID, Set<CardType>>();

    HurkylMasterWizardWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && !spell.isCreature(game)) {
            this.map.computeIfAbsent(event.getPlayerId(), x -> new HashSet()).addAll(spell.getCardType(game));
        }
    }

    public void reset() {
        this.map.clear();
        super.reset();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((HurkylMasterWizardWatcher)game.getState().getWatcher(HurkylMasterWizardWatcher.class)).map.containsKey(source.getControllerId());
    }

    static Set<CardType> getCardTypes(Ability source, Game game) {
        return ((HurkylMasterWizardWatcher)game.getState().getWatcher(HurkylMasterWizardWatcher.class)).map.getOrDefault(source.getControllerId(), Collections.emptySet());
    }
}

