/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.counters.Counter;
import mage.game.Game;

enum HydraTrainerValue implements DynamicValue
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        return game.getBattlefield().getAllActivePermanents(sourceAbility.getControllerId()).stream().filter(Objects::nonNull).map(perm -> perm.getCounters(game)).flatMap(counters -> counters.values().stream()).mapToInt(Counter::getCount).sum();
    }

    public HydraTrainerValue copy() {
        return this;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "the number of counters on permanents you control";
    }

    static {
        hint = new ValueHint("Number of counters on permanents you control", (DynamicValue)instance);
    }
}

