/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class HydradoodleEffect
extends OneShotEffect {
    HydradoodleEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "roll X six-sided dice. {this} enters with a number of +1/+1 counters on it equal to the total of those results";
    }

    private HydradoodleEffect(HydradoodleEffect effect) {
        super((OneShotEffect)effect);
    }

    public HydradoodleEffect copy() {
        return new HydradoodleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent != null && controller != null) {
            int amount = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            if (amount > 0) {
                int total = controller.rollDice(this.outcome, source, game, 6, amount, 0).stream().mapToInt(x -> x).sum();
                ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
                permanent.addCounters(CounterType.P1P1.createInstance(total), source.getControllerId(), source, game, (List)appliedEffects);
            }
            return true;
        }
        return false;
    }
}

