/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlueManaAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HydroManFluidFelonEffect
extends ContinuousEffectImpl {
    HydroManFluidFelonEffect() {
        super(Duration.UntilYourNextTurn, Outcome.Neutral);
        this.staticText = "Until your next turn, he becomes a land and gains \"{T}: Add {U}.\"";
        this.addDependencyType(DependencyType.BecomeNonbasicLand);
    }

    protected HydroManFluidFelonEffect(HydroManFluidFelonEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.removeAllCreatureTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.LAND});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    public HydroManFluidFelonEffect copy() {
        return new HydroManFluidFelonEffect(this);
    }
}

