/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnyColorLandsProduceManaEffect
extends ManaEffect {
    private boolean inManaTypeCalculation = false;

    AnyColorLandsProduceManaEffect() {
        this.staticText = "Add one mana of any type that a land you control could produce. If {this} has a +1/+1 counter on it, add three mana of that type instead.";
    }

    private AnyColorLandsProduceManaEffect(AnyColorLandsProduceManaEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int manaAmount = this.getManaAmount(game, source);
        ArrayList<Mana> netManas = new ArrayList<Mana>();
        Mana types = this.getManaTypes(game, source);
        if (types.getRed() > 0) {
            netManas.add(Mana.RedMana((int)manaAmount));
        }
        if (types.getGreen() > 0) {
            netManas.add(Mana.GreenMana((int)manaAmount));
        }
        if (types.getBlue() > 0) {
            netManas.add(Mana.BlueMana((int)manaAmount));
        }
        if (types.getWhite() > 0) {
            netManas.add(Mana.WhiteMana((int)manaAmount));
        }
        if (types.getBlack() > 0) {
            netManas.add(Mana.BlackMana((int)manaAmount));
        }
        if (types.getColorless() > 0) {
            netManas.add(Mana.ColorlessMana((int)manaAmount));
        }
        if (types.getAny() > 0) {
            netManas.add(Mana.AnyMana((int)manaAmount));
        }
        return netManas;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        int manaAmount = this.getManaAmount(game, source);
        Mana types = this.getManaTypes(game, source);
        ChoiceColor choice = new ChoiceColor(true);
        choice.getChoices().clear();
        choice.setMessage("Pick a mana color");
        if (types.getBlack() > 0) {
            choice.getChoices().add("Black");
        }
        if (types.getRed() > 0) {
            choice.getChoices().add("Red");
        }
        if (types.getBlue() > 0) {
            choice.getChoices().add("Blue");
        }
        if (types.getGreen() > 0) {
            choice.getChoices().add("Green");
        }
        if (types.getWhite() > 0) {
            choice.getChoices().add("White");
        }
        if (types.getColorless() > 0) {
            choice.getChoices().add("Colorless");
        }
        if (types.getAny() > 0) {
            choice.getChoices().add("Black");
            choice.getChoices().add("Red");
            choice.getChoices().add("Blue");
            choice.getChoices().add("Green");
            choice.getChoices().add("White");
            choice.getChoices().add("Colorless");
        }
        if (!choice.getChoices().isEmpty()) {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null) {
                return mana;
            }
            if (choice.getChoices().size() == 1) {
                choice.setChoice((String)choice.getChoices().iterator().next());
            } else if (!player.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
                return mana;
            }
            if (choice.getChoice() != null) {
                switch (choice.getChoice()) {
                    case "Black": {
                        mana.setBlack(manaAmount);
                        break;
                    }
                    case "Blue": {
                        mana.setBlue(manaAmount);
                        break;
                    }
                    case "Red": {
                        mana.setRed(manaAmount);
                        break;
                    }
                    case "Green": {
                        mana.setGreen(manaAmount);
                        break;
                    }
                    case "White": {
                        mana.setWhite(manaAmount);
                        break;
                    }
                    case "Colorless": {
                        mana.setColorless(manaAmount);
                    }
                }
            }
        }
        return mana;
    }

    public AnyColorLandsProduceManaEffect copy() {
        return new AnyColorLandsProduceManaEffect(this);
    }

    private int getManaAmount(Game game, Ability source) {
        Permanent permanent;
        if (game != null && (permanent = game.getPermanent(source.getSourceId())) != null && permanent.getCounters(game).getCount(CounterType.P1P1) > 0) {
            return 3;
        }
        return 1;
    }

    private Mana getManaTypes(Game game, Ability source) {
        Mana types = new Mana();
        if (game == null || game.getPhase() == null) {
            return types;
        }
        if (this.inManaTypeCalculation) {
            return types;
        }
        this.inManaTypeCalculation = true;
        List lands = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND, source.getControllerId(), source, game);
        for (Permanent land : lands) {
            Abilities mana = land.getAbilities().getActivatedManaAbilities(Zone.BATTLEFIELD);
            for (ActivatedManaAbilityImpl ability : mana) {
                if (ability.equals(source) || !ability.definesMana(game)) continue;
                for (Mana netMana : ability.getNetMana(game)) {
                    types.add(netMana);
                }
            }
        }
        this.inManaTypeCalculation = false;
        return types;
    }
}

