/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;

class IbHalfheartGoblinTacticianEffect
extends OneShotEffect {
    IbHalfheartGoblinTacticianEffect() {
        super(Outcome.Damage);
        this.staticText = "sacrifice it. If you do, it deals 4 damage to each creature blocking it";
    }

    private IbHalfheartGoblinTacticianEffect(IbHalfheartGoblinTacticianEffect effect) {
        super((OneShotEffect)effect);
    }

    public IbHalfheartGoblinTacticianEffect copy() {
        return new IbHalfheartGoblinTacticianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent blockedCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (blockedCreature == null) {
            return true;
        }
        HashSet blockingCreatures = new HashSet();
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (!combatGroup.getAttackers().contains(blockedCreature.getId())) continue;
            blockingCreatures.addAll(combatGroup.getBlockers());
        }
        if (blockedCreature.sacrifice(source, game)) {
            for (UUID blockerId : blockingCreatures) {
                Permanent blockingCreature = game.getPermanent(blockerId);
                if (blockingCreature == null) continue;
                blockingCreature.damage(4, blockedCreature.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

