/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IceCauldronCastFromExileEffect
extends AsThoughEffectImpl {
    IceCauldronCastFromExileEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.Custom, Outcome.Benefit);
        this.staticText = "You may cast that card for as long as it remains exiled";
    }

    private IceCauldronCastFromExileEffect(IceCauldronCastFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IceCauldronCastFromExileEffect copy() {
        return new IceCauldronCastFromExileEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (this.getTargetPointer().getTargets(game, source).contains(objectId) && game.getState().getZone(objectId) == Zone.EXILED) {
            Player player = game.getPlayer(source.getControllerId());
            Card card = game.getCard(objectId);
            return player != null && card != null;
        }
        return false;
    }
}

