/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.i.IceCauldronCastFromExileEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IceCauldronExileEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("nonland card");

    public IceCauldronExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile a nonland card from your hand. You may cast that card for as long as it remains exiled";
    }

    private IceCauldronExileEffect(IceCauldronExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IceCauldronExileEffect copy() {
        return new IceCauldronExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            if (controller.getHand().isEmpty()) {
                return true;
            }
            TargetCard target = new TargetCard(Zone.HAND, filter);
            target.withNotTarget(true);
            Card chosenCard = null;
            if (controller.choose(Outcome.Benefit, (Target)target, source, game)) {
                chosenCard = controller.getHand().get(target.getFirstTarget(), game);
            }
            if (chosenCard != null) {
                controller.moveCardToExileWithInfo(chosenCard, source.getSourceId(), sourcePermanent.getIdName(), source, game, Zone.HAND, true);
                IceCauldronCastFromExileEffect effect = new IceCauldronCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(chosenCard.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
                game.getState().setValue("IceCauldronCard" + source.getSourceId().toString(), (Object)new MageObjectReference(chosenCard.getId(), game));
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

