/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class IceCaveEffect
extends OneShotEffect {
    IceCaveEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "any other player may pay that spell's mana cost. If a player does, counter the spell";
    }

    private IceCaveEffect(IceCaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public IceCaveEffect copy() {
        return new IceCaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Spell spell = (Spell)game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (sourcePermanent != null && spell != null && controller != null) {
            Player spellController = game.getPlayer(spell.getControllerId());
            ManaCostsImpl cost = new ManaCostsImpl(spell.getSpellAbility() == null ? "" : spell.getSpellAbility().getManaCosts().getText());
            if (spellController != null) {
                for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    Player player = game.getPlayer(playerId);
                    if (player == null || player.equals(spellController)) continue;
                    cost.clearPaid();
                    if (!cost.canPay(source, source, player.getId(), game) || !player.chooseUse(this.outcome, "Pay " + cost.getText() + " to counter " + spell.getIdName() + '?', source, game) || !cost.pay(source, game, source, playerId, false, null)) continue;
                    game.informPlayers(player.getLogName() + " pays" + cost.getText() + " to counter " + spell.getIdName() + '.');
                    game.getStack().counter(spell.getId(), source, game);
                    break;
                }
            }
        }
        return true;
    }
}

