/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class IdolOfEnduranceWatcher
extends Watcher {
    private final Map<MageObjectReference, Map<UUID, Integer>> morMap = new HashMap<MageObjectReference, Map<UUID, Integer>>();

    IdolOfEnduranceWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            if (event.getApprovingObject() == null) {
                return;
            }
            this.morMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), m -> new HashMap()).compute(event.getPlayerId(), (u, i) -> i == null ? 0 : Integer.sum(i, -1));
        }
    }

    public void reset() {
        this.morMap.clear();
        super.reset();
    }

    static boolean checkPermission(UUID playerId, Ability source, Game game) {
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        IdolOfEnduranceWatcher watcher = (IdolOfEnduranceWatcher)game.getState().getWatcher(IdolOfEnduranceWatcher.class);
        MageObjectReference mor = new MageObjectReference(source);
        return watcher.morMap.containsKey(mor) && watcher.morMap.get(mor).getOrDefault(playerId, 0) > 0;
    }

    static void addPlayable(Ability source, Game game) {
        MageObjectReference mor = new MageObjectReference(source);
        ((IdolOfEnduranceWatcher)game.getState().getWatcher(IdolOfEnduranceWatcher.class)).morMap.computeIfAbsent(mor, m -> new HashMap()).compute(source.getControllerId(), CardUtil::setOrIncrementValue);
    }
}

