/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class IdrisSoulOfTheTARDISGainEffect
extends ContinuousEffectImpl {
    IdrisSoulOfTheTARDISGainEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "{this} has all activated and triggered abilities of the exiled card and gets +X/+X, where X is the exiled card's mana value";
    }

    private IdrisSoulOfTheTARDISGainEffect(IdrisSoulOfTheTARDISGainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public IdrisSoulOfTheTARDISGainEffect copy() {
        return new IdrisSoulOfTheTARDISGainEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)game.getState().getZoneChangeCounter(source.getSourceId())));
        if (permanent == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        switch (layer) {
            case AbilityAddingRemovingEffects_6: {
                Set abilities = exileZone.getCards(game).stream().map(card -> card.getAbilities(game)).flatMap(Collection::stream).filter(ability -> ability.isActivatedAbility() || ability.isTriggeredAbility()).collect(Collectors.toSet());
                for (Ability ability2 : abilities) {
                    permanent.addAbility(ability2, source.getSourceId(), game);
                }
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.ModifyPT_7c) break;
                int boost = exileZone.getCards(game).stream().mapToInt(MageObject::getManaValue).sum();
                permanent.addPower(boost);
                permanent.addToughness(boost);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

