/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.ReturnFromExileEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class IgnorantBlissEffect
extends OneShotEffect {
    IgnorantBlissEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all cards from your hand face down. At the beginning of the next end step, return those cards to your hand, then draw a card";
    }

    private IgnorantBlissEffect(IgnorantBlissEffect effect) {
        super((OneShotEffect)effect);
    }

    public IgnorantBlissEffect copy() {
        return new IgnorantBlissEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl hand = new CardsImpl((Collection)controller.getHand());
        controller.moveCardsToExile(hand.getCards(game), source, game, false, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        hand.getCards(game).stream().filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.EXILED).forEach(card -> card.setFaceDown(true, game));
        AtTheBeginOfNextEndStepDelayedTriggeredAbility ability = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnFromExileEffect(Zone.HAND));
        ability.addEffect((Effect)new DrawCardSourceControllerEffect(1));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)ability, source);
        return true;
    }
}

