/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class IlhargTheRazeBoarEffect
extends OneShotEffect {
    IlhargTheRazeBoarEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put a creature card from your hand onto the battlefield tapped and attacking. Return that creature to your hand at the beginning of the next end step.";
    }

    private IlhargTheRazeBoarEffect(IlhargTheRazeBoarEffect effect) {
        super((OneShotEffect)effect);
    }

    public IlhargTheRazeBoarEffect copy() {
        return new IlhargTheRazeBoarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        if (!player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game)) {
            return false;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.getCombat().addAttackingCreature(permanent.getId(), game);
        ReturnToHandTargetEffect effect = new ReturnToHandTargetEffect();
        effect.setText("return " + permanent.getName() + " to its owner's hand");
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

