/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ForestwalkAbility;
import mage.abilities.keyword.IslandwalkAbility;
import mage.abilities.keyword.MountainwalkAbility;
import mage.abilities.keyword.PlainswalkAbility;
import mage.abilities.keyword.SwampwalkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;

class IllusionaryPresenceEffect
extends OneShotEffect {
    Ability gainedAbility;

    public IllusionaryPresenceEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} gains landwalk of the chosen type until end of turn";
    }

    private IllusionaryPresenceEffect(IllusionaryPresenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public IllusionaryPresenceEffect copy() {
        return new IllusionaryPresenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SubType landTypeChoice;
        MageObject mageObject = game.getObject(source);
        if (mageObject != null && (landTypeChoice = SubType.byDescription((String)((String)game.getState().getValue(mageObject.getId().toString() + "BasicLandType")))) != null) {
            switch (landTypeChoice) {
                case PLAINS: {
                    this.gainedAbility = new PlainswalkAbility();
                    break;
                }
                case FOREST: {
                    this.gainedAbility = new ForestwalkAbility();
                    break;
                }
                case SWAMP: {
                    this.gainedAbility = new SwampwalkAbility();
                    break;
                }
                case ISLAND: {
                    this.gainedAbility = new IslandwalkAbility();
                    break;
                }
                case MOUNTAIN: {
                    this.gainedAbility = new MountainwalkAbility();
                }
            }
            if (this.gainedAbility != null) {
                GainAbilitySourceEffect effect = new GainAbilitySourceEffect(this.gainedAbility, Duration.EndOfTurn);
                game.addEffect((ContinuousEffect)effect, source);
                return true;
            }
        }
        return false;
    }
}

