/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IllusionaryTerrainEffect
extends ContinuousEffectImpl {
    IllusionaryTerrainEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "Basic lands of the first chosen type are the second chosen type";
    }

    private IllusionaryTerrainEffect(IllusionaryTerrainEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public IllusionaryTerrainEffect copy() {
        return new IllusionaryTerrainEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        SubType firstChoice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "firstChoice")));
        SubType secondChoice = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "secondChoice")));
        List lands = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game);
        if (controller != null && firstChoice != null && secondChoice != null) {
            for (Permanent land : lands) {
                if (!land.isBasic(game)) continue;
                switch (layer) {
                    case TypeChangingEffects_4: {
                        if (!land.hasSubtype(firstChoice, game)) break;
                        land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                        land.addSubType(game, new SubType[]{secondChoice});
                        land.removeAllAbilities(source.getSourceId(), game);
                        if (land.hasSubtype(SubType.FOREST, game)) {
                            this.dependencyTypes.add(DependencyType.BecomeForest);
                            land.addAbility((Ability)new GreenManaAbility(), source.getSourceId(), game);
                        }
                        if (land.hasSubtype(SubType.PLAINS, game)) {
                            this.dependencyTypes.add(DependencyType.BecomePlains);
                            land.addAbility((Ability)new WhiteManaAbility(), source.getSourceId(), game);
                        }
                        if (land.hasSubtype(SubType.MOUNTAIN, game)) {
                            this.dependencyTypes.add(DependencyType.BecomeMountain);
                            land.addAbility((Ability)new RedManaAbility(), source.getSourceId(), game);
                        }
                        if (land.hasSubtype(SubType.ISLAND, game)) {
                            this.dependencyTypes.add(DependencyType.BecomeIsland);
                            land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                        }
                        if (!land.hasSubtype(SubType.SWAMP, game)) break;
                        this.dependencyTypes.add(DependencyType.BecomeSwamp);
                        land.addAbility((Ability)new BlackManaAbility(), source.getSourceId(), game);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4;
    }
}

